/*
Tento celý súbor je licencovaný pod GNU GENERAL PUBLIC LICENSE version 3 https://www.gnu.org/licenses/gpl-3.0.html
Autor: Adam Struharňanský
Neexistujú absolútne žiadne záruky funčnosti a použitelnosti na žiaden účel,
a všetci autori sa zriekajú zodpovednosti za akékoľvek škody vyplývajúce z jeho použitia.

There are absolutely no warranties of functionality and/or usability for any purpose,
and all authors disclaim liability for any damages resulting from its use.
*/

#include <iostream>
#include "graph_maker.hpp"
#include "ilp_solver.hpp"
#include "ford_fulkerson.hpp"
#include "dinic.hpp"
#include <time.h>       /* time */

int main()
{
	std::vector<std::vector<pair<int, int>>> g = random_graph(50, 150, 100);
	int ilp = ilp_solver_max_flow(g);
	int ff = ford_fulkerson_max_flown(g);
	int d = dinic_max_flow(g);

	std::cout << "linear programming: " << ilp << ", ford-fulkerson: " << ff << " dinic: " << d << " \n";

	return 0;	
}


